
import java.awt.geom.Ellipse2D;
import java.awt.Rectangle;

public class BadSpark extends GameObject
{
	private int vx;
    private int vy;
    private TileMap map;
    private Rectangle boundary;

    public BadSpark(CircuitConductor cc, TileMap map)
    {
		super(cc);
        this.map = map;
        boundary = new Rectangle((int)x,(int)y,(int)width,(int)height);
        setSpriteNames(new String[] {"BadSparkSpiralGlow1.png","BadSparkSpiralGlow2.png",
                                     "BadSparkSpiralGlow3.png","BadSparkSpiralGlow4.png"});
        setAnimationSpeed(10);
      }

      public void move()
      {
		super.move();

        if(!map.xBlocked(this.getX(),this.getY(),this.getVx(),this.getVy(),
                         this.getWidth(),this.getHeight(),this))
		  x += vx;
		else
		  vx = -vx;
	    if(!map.yBlocked(this.getX(),this.getY(),vx,vy,this.getWidth(),this.getHeight()))
		  y += vy;
		else
		  vy = -vy;

      }

      public void collision(GameObject inGameObject)
      {

	  }

	  public void setBounds(int xPos, int yPos, int width, int height)
	  {
		  boundary.setBounds(xPos,yPos,width,height);
      }

	  public Rectangle getBounds()
	  {
		  return boundary.getBounds();
	  }

      public int getVx()
      {
		  return vx;
      }
      public void setVx(int inVx)
      {
		  vx = inVx;
	  }

      public int getVy()
      {
		  return vy;
	  }
      public void setVy(int inVy)
      {
		  vy = inVy;
	  }
}
